/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIClient;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsConstants;
import com.ibm.hwmca.fw.ui.UIObjectsOffsets;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UIObjectsReader
extends UIObjectProperties
implements UILog {
    private HashMap listeners;
    private Object listenersLock = new Object();
    private File objectsFile;
    private RandomAccessFile objectsReader;
    private UIObjectsOffsets recordOffsets;
    private File unacceptableFile;
    private File rootFile;
    private String groupFilePrefix;
    private String taskGroupFilePrefix;
    private String moGroupFilePrefix;
    private Set allowedShortIds;
    private static final String TRACE_MASKT = "HUIOBJRT";
    private static final String TRACE_MASKF = "HUIOBJRF";
    private static final String TRACE_MASKD = "HUIOBJRD";

    public UIObjectsReader() throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.UIObjectsReader()");
        String pathName = BaseFileControl.getFilePath("uitmp");
        File path = new File(pathName);
        this.groupFilePrefix = pathName + "group.";
        this.taskGroupFilePrefix = this.groupFilePrefix + "task.";
        this.moGroupFilePrefix = this.groupFilePrefix + "mo.";
        this.objectsFile = new File(pathName + "objects");
        this.objectsReader = new RandomAccessFile(this.objectsFile, "rws");
        this.recordOffsets = new UIObjectsOffsets(this.objectsReader);
        this.unacceptableFile = new File(pathName + "unacceptablemanagedobjects");
        this.rootFile = new File(pathName + "rootmanagedobjects");
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.UIObjectsReader()");
    }

    UIObjectsReader(Set allowedShortIds) throws IOException, HException {
        this();
        this.allowedShortIds = allowedShortIds;
    }

    public void close() {
        try {
            this.objectsReader.close();
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1797, ioexc).log();
        }
    }

    public Set getNoTargetRequiredTasks() {
        HashSet<String> result = new HashSet<String>();
        List consoleTasks = this.getAllConsoleTaskShortIds();
        Set ids = this.getShortIdsByType((byte)51);
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            try {
                String shortId = (String)iterator.next();
                byte[] buffer = this.getBuffer(shortId);
                if (UIObjectsReader.isTargetRequired(buffer) || consoleTasks.contains(shortId)) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
            }
        }
        return result;
    }

    public Set getAllowedTasks(String shortId) {
        byte[] buffer = this.getBuffer(shortId);
        if (!UIObjectsReader.isManagedObject(buffer) && !UIObjectsReader.isManagedObjectGroup(buffer)) {
            throw new IllegalArgumentException("Argument [" + shortId + "] passed to UIObjectReader.getAllowedTasks() does not represent not a managed object or managed object group.");
        }
        return UIClient.getAllowedTasks(shortId);
    }

    public synchronized List getChildrenShortIds(String parentShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getChildrenShortIds()");
        ArrayList result = new ArrayList();
        String fileName = this.moGroupFilePrefix + parentShortId;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                this.parseFile(file, result, true);
            } else {
                List likeTaskGroups = this.getLikeTaskGroupShortIds(parentShortId);
                Iterator iterator = likeTaskGroups.iterator();
                while (iterator.hasNext()) {
                    fileName = this.taskGroupFilePrefix + iterator.next();
                    file = new File(fileName);
                    if (!file.exists()) continue;
                    this.parseFile(file, result, false);
                }
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1798, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getChildrenShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized List getTaskShortIdsForGroup(String taskGroupShortId, boolean returnSameMergedKey) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getTaskShortIdsForGroup(), group is " + taskGroupShortId);
        ArrayList result = new ArrayList();
        String fileName = null;
        try {
            List likeTaskGroups = this.getLikeTaskGroupShortIds(taskGroupShortId);
            ArrayList children = new ArrayList();
            Iterator iterator = likeTaskGroups.iterator();
            while (iterator.hasNext()) {
                fileName = this.taskGroupFilePrefix + iterator.next();
                File file = new File(fileName);
                this.parseFile(file, children, false);
            }
            this.getLeaves(children, result);
            if (!returnSameMergedKey) {
                HashMap<String, String> map = new HashMap<String, String>();
                int size = result.size();
                for (int i = 0; i < size; ++i) {
                    String shortId = (String)result.get(i);
                    try {
                        byte[] buffer = this.getBuffer(shortId);
                        String mergedKey = UIObjectsReader.getMergedKey(buffer);
                        if (mergedKey == null) {
                            map.put(shortId, shortId);
                            continue;
                        }
                        map.put(mergedKey, shortId);
                        continue;
                    }
                    catch (InvalidIdException exc) {
                        Trace.trace(TRACE_MASKF, exc.toString());
                    }
                }
                result.clear();
                result.addAll(map.values());
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1799, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getTaskShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized List getLeavesForGroup(String groupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getLeavesForGroup(), group is " + groupShortId);
        ArrayList result = new ArrayList();
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(groupShortId);
        String fileName = null;
        try {
            this.getLeaves(groups, result);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1818, ioexc);
            log.add("file name is " + fileName);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getTaskShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getUnacceptableShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getUnacceptableShortIds()");
        HashSet result = new HashSet();
        try {
            this.parseFile(this.unacceptableFile, result, false);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1800, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getUnacceptableShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getUnacceptableManagedObjectShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getUnacceptableManagedObjectShortIds()");
        Set result = this.getShortIdsByType((byte)49, this.getUnacceptableShortIds());
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getUnacceptableManagedObjectShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getUnacceptableManagedObjectShortIdsForGroup(String groupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getUnacceptableManagedObjectShortIdsForGrou()");
        HashSet<String> result = new HashSet<String>();
        Set leaves = this.getShortIdsByType((byte)49, this.getLeavesForGroup(groupShortId));
        Set allUnacceptable = this.getUnacceptableShortIds();
        Iterator iterator = leaves.iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (!allUnacceptable.contains(next)) continue;
            result.add(next);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getUnacceptableManagedObjectShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getAttentionManagedObjectShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getAttentionManagedObjectShortIds()");
        HashSet<String> result = new HashSet<String>();
        Set managedObjects = this.getShortIdsByType((byte)49);
        Iterator iterator = managedObjects.iterator();
        while (iterator.hasNext()) {
            try {
                String shortId = (String)iterator.next();
                byte[] buffer = this.getBuffer(shortId);
                if (!UIObjectsReader.attentionsExist(buffer)) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getAttentionManagedObjectShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getAttentionManagedObjectShortIdsForGroup(String groupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getAttentionManagedObjectShortIdsForGroup()");
        HashSet<String> result = new HashSet<String>();
        Set leaves = this.getShortIdsByType((byte)49, this.getLeavesForGroup(groupShortId));
        Iterator iterator = leaves.iterator();
        while (iterator.hasNext()) {
            try {
                String shortId = (String)iterator.next();
                byte[] buffer = this.getBuffer(shortId);
                if (!UIObjectsReader.attentionsExist(buffer)) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getAttentionManagedObjectShortIdsForGroup(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getShortIdsByType(byte type) {
        return this.getShortIdsByType(type, false);
    }

    public synchronized Set getShortIdsByType(byte type, Collection shortIds) {
        return this.getShortIdsByType(type, false, shortIds);
    }

    public synchronized Set getShortIdsByType(byte type, boolean deleted) {
        return this.getShortIdsByType(type, deleted, null);
    }

    public synchronized Set getShortIdsByType(byte type, boolean deleted, Collection shortIds) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getShortIdsByType()");
        HashSet<String> result = new HashSet<String>();
        try {
            int numRecords = (int)(this.objectsReader.length() / 769L);
            byte[] buffer = new byte[769];
            for (int i = 0; i < numRecords; ++i) {
                byte nextType;
                this.objectsReader.seek(i * 769);
                this.objectsReader.read(buffer, 0, 769);
                String shortId = UIObjectsReader.getShortId(buffer);
                if (!this.isAllowed(shortId) || !deleted && UIObjectsReader.isDeleted(buffer) || (nextType = UIObjectsReader.getType(buffer)) != type && (type != 49 || nextType != 53) || shortIds != null && !shortIds.contains(shortId)) continue;
                result.add(shortId);
            }
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1810, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getShortIdsByType(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getRootManagedObjectShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getRootManagedObjectShortIds()");
        HashSet result = new HashSet();
        try {
            HashSet allRoots = new HashSet();
            this.parseFile(this.rootFile, allRoots, true);
            this.getTypes(allRoots, result, (byte)49);
            this.getTypes(allRoots, result, (byte)50);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1801, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getRootManagedObjectShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getRootManagedObjectGroupShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getRootManagedObjectGroupShortIds()");
        HashSet result = new HashSet();
        try {
            HashSet allRoots = new HashSet();
            this.parseFile(this.rootFile, allRoots, true);
            this.getTypes(allRoots, result, (byte)50);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1801, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getRootManagedObjectGroupShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized Set getRootTaskShortIds(boolean includeConsoleTasksGroup) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getRootTaskShortIds()");
        Set result = new HashSet();
        try {
            HashSet allRoots = new HashSet();
            this.parseFile(this.rootFile, allRoots, false);
            this.getTypes(allRoots, result, (byte)52);
            if (!includeConsoleTasksGroup) {
                result.removeAll(this.findConsoleTasksGroupShortIds(result));
            }
            result = this.removeLikeNames(result);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
            new FrameworkLog(UILog.logInfo, 1802, ioexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getRootTaskShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized List getConsoleTaskShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getConsoleTaskShortIds()");
        ArrayList<String> result = new ArrayList<String>();
        Set consoleTasksGroupShortIds = this.findConsoleTasksGroupShortIds(this.getRootTaskShortIds(true));
        if (consoleTasksGroupShortIds.size() > 0) {
            Iterator iterator = consoleTasksGroupShortIds.iterator();
            while (iterator.hasNext()) {
                List children = this.getChildrenShortIds((String)iterator.next());
                Iterator iterator2 = children.iterator();
                while (iterator2.hasNext()) {
                    String next = (String)iterator2.next();
                    if (result.contains(next)) continue;
                    result.add(next);
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getConsoleTaskShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized List getAllConsoleTaskShortIds() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getAllConsoleTaskShortIds()");
        ArrayList result = new ArrayList();
        Set consoleTasksGroupShortIds = this.findConsoleTasksGroupShortIds(this.getRootTaskShortIds(true));
        if (consoleTasksGroupShortIds.size() > 0) {
            Iterator iterator = consoleTasksGroupShortIds.iterator();
            while (iterator.hasNext()) {
                this.addConsoleTasks((String)iterator.next(), result);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getAllConsoleTaskShortIds(), number returned is " + result.size());
        return result;
    }

    public synchronized byte[] getBuffer(String shortId) throws InvalidIdException {
        return this.getBuffer(shortId, false);
    }

    public synchronized byte[] getBuffer(String shortId, boolean deleted) throws InvalidIdException {
        byte[] buffer;
        block7: {
            buffer = null;
            try {
                if (this.isAllowed(shortId)) {
                    buffer = new byte[769];
                    int offset = this.recordOffsets.getOffset(shortId);
                    this.objectsReader.seek(offset + 0);
                    int numRead = this.objectsReader.read(buffer, 0, 769);
                    if (numRead != 769) {
                        throw new InvalidIdException("Could not read shortId " + shortId + ", should have read " + 769 + " bytes but only " + numRead + " bytes read.");
                    }
                    if (!deleted && buffer[8] == 84) {
                        throw new InvalidIdException("ShortId " + shortId + " has been deleted.");
                    }
                    break block7;
                }
                throw new InvalidIdException("ShortId " + shortId + " is not allowed in the current user context.");
            }
            catch (IOException ioexc) {
                InvalidIdException exc = new InvalidIdException("Could not read shortId " + shortId + ".  Exception is " + ioexc);
                Trace.trace(TRACE_MASKF, exc);
                throw exc;
            }
            catch (NumberFormatException nfexc) {
                InvalidIdException exc = new InvalidIdException("'Integer.parseInt(" + shortId + ",16)' threw exception " + nfexc);
                Trace.trace(TRACE_MASKF, exc.toString());
                throw exc;
            }
            catch (InvalidIdException exc) {
                Trace.trace(TRACE_MASKF, exc.toString());
                throw exc;
            }
        }
        return buffer;
    }

    public synchronized Map getProperties(Collection shortIds, String[] propertyNames, Locale locale) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getProperties()");
        HashMap result = new HashMap();
        Iterator iterator = shortIds.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            try {
                byte[] buffer = this.getBuffer(shortId);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                result.put(shortId, properties);
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (propertyNames[i] == "Name") {
                        properties.put(propertyNames[i], UIObjectsReader.getLocalizedName(buffer, locale));
                        continue;
                    }
                    if (propertyNames[i] == "NameKey") {
                        properties.put(propertyNames[i], UIObjectsReader.getNameKey(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Caption") {
                        properties.put(propertyNames[i], UIObjectsReader.getLocalizedCaption(buffer, locale));
                        continue;
                    }
                    if (propertyNames[i] == "CaptionKey") {
                        properties.put(propertyNames[i], UIObjectsReader.getCaptionKey(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "ObjectIdNameKey") {
                        properties.put(propertyNames[i], UIObjectsReader.getObjectIdNameKey(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Status") {
                        properties.put(propertyNames[i], UIObjectsReader.getLocalizedStatusText(buffer, locale));
                        continue;
                    }
                    if (propertyNames[i] == "StatusShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getStatusShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Image") {
                        properties.put(propertyNames[i], UIObjectsReader.getImageName(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "Type") {
                        properties.put(propertyNames[i], new Byte(UIObjectsReader.getType(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Root") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isRoot(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Busy") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isBusy(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Locked") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isLocked(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "Acceptable") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isStatusAcceptable(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "AttentionsExist") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.attentionsExist(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "AttentionTaskShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getAttentionTaskShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "TargetRequired") {
                        properties.put(propertyNames[i], new Boolean(UIObjectsReader.isTargetRequired(buffer)));
                        continue;
                    }
                    if (propertyNames[i] == "ClassTypeShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getClassTypeShortId(buffer));
                        continue;
                    }
                    if (propertyNames[i] == "OpenTaskShortId") {
                        properties.put(propertyNames[i], UIObjectsReader.getOpenTaskShortId(buffer));
                        continue;
                    }
                    throw new IllegalArgumentException("Property name [" + propertyNames[i] + "] is not a valid property name.");
                }
            }
            catch (InvalidIdException exc) {
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getProperties()");
        return result;
    }

    public static String[] sortByName(Map properties) {
        String[] keys = properties.keySet().toArray(new String[properties.size()]);
        for (int i = 0; i < keys.length; ++i) {
            Map map = (Map)properties.get(keys[i]);
            String name1 = (String)map.get("Name");
            if (name1 == null) {
                throw new IllegalArgumentException("NAME_PROPERTY is not in the Map argument.");
            }
            for (int j = i + 1; j < keys.length; ++j) {
                map = (Map)properties.get(keys[j]);
                String name2 = (String)map.get("Name");
                if (name2 == null) {
                    throw new IllegalArgumentException("NAME_PROPERTY is not in the Map argument.");
                }
                if (name2.compareToIgnoreCase(name1) >= 0) continue;
                String temp = keys[i];
                keys[i] = keys[j];
                keys[j] = temp;
                name1 = name2;
            }
        }
        return keys;
    }

    public static String[] sortTasksByObjectIdNameKey(Map properties, String parentKey) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.sortTasksByObjectIdNameKey(), parentKey is " + parentKey);
        String[] result = null;
        String[] taskKeys = null;
        for (int i = 0; i < UIObjectsConstants.TASK_GROUP_KEYS.length; ++i) {
            if (!parentKey.equals(UIObjectsConstants.TASK_GROUP_KEYS[i])) continue;
            taskKeys = UIObjectsConstants.TASK_GROUPS[i];
            break;
        }
        if (taskKeys == null) {
            Trace.trace(TRACE_MASKF, "   'parentKey' argument is unknown");
            result = UIObjectsReader.sortByName(properties);
        } else {
            int i;
            String[] shortIds = new String[taskKeys.length];
            HashMap<String, Map> unknownShortIds = null;
            Iterator iterator = properties.keySet().iterator();
            int next = 0;
            while (iterator.hasNext()) {
                boolean found = false;
                String shortId = (String)iterator.next();
                Map map = (Map)properties.get(shortId);
                String key = (String)map.get("ObjectIdNameKey");
                if (key != null) {
                    for (int i2 = 0; i2 < taskKeys.length; ++i2) {
                        if (!key.equals(taskKeys[i2])) continue;
                        shortIds[i2] = shortId;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                if (unknownShortIds == null) {
                    unknownShortIds = new HashMap<String, Map>();
                }
                unknownShortIds.put(shortId, map);
            }
            int numTasks = 0;
            for (i = 0; i < shortIds.length; ++i) {
                if (shortIds[i] == null) continue;
                ++numTasks;
            }
            if (unknownShortIds != null) {
                numTasks += unknownShortIds.size();
            }
            next = 0;
            result = new String[numTasks];
            for (i = 0; i < shortIds.length; ++i) {
                if (shortIds[i] == null) continue;
                result[next++] = shortIds[i];
            }
            if (unknownShortIds != null) {
                shortIds = UIObjectsReader.sortByName(unknownShortIds);
                for (i = 0; i < shortIds.length; ++i) {
                    result[next++] = shortIds[i];
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.sortTasksByObjectIdNameKey()");
        return result;
    }

    public static String[] sortTasksGroupsByObjectIdNameKey(Map properties) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.sortTaskGroupsByObjectIdNameKey()");
        String[] result = new String[properties.size()];
        int next = 0;
        block0: for (int i = 0; i < UIObjectsConstants.TASK_GROUP_KEYS.length; ++i) {
            boolean found = false;
            Iterator iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String shortId = (String)iterator.next();
                Map map = (Map)properties.get(shortId);
                String key = (String)map.get("ObjectIdNameKey");
                if (key == null) {
                    throw new IllegalArgumentException("UIObjectsReader.OBJECT_ID_NAME_KEY_PROPERTY not in Map.  shortId is " + shortId);
                }
                if (!key.equals(UIObjectsConstants.TASK_GROUP_KEYS[i])) continue;
                result[next++] = shortId;
                found = true;
                continue block0;
            }
        }
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            Map map = (Map)properties.get(shortId);
            String key = (String)map.get("ObjectIdNameKey");
            boolean found = false;
            int numKnown = next;
            for (int i = 0; i < UIObjectsConstants.TASK_GROUP_KEYS.length; ++i) {
                if (!key.equals(UIObjectsConstants.TASK_GROUP_KEYS[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            result[next++] = shortId;
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.sortTaskGroupsByObjectIdNameKey()");
        return result;
    }

    private void parseFile(File file, Collection list, boolean allowDuplicates) throws IOException {
        Trace.trace(TRACE_MASKD, "-> UIObjectsReader.parseFile(), file name is " + file.getAbsoluteFile());
        if (file.exists()) {
            char[] buffer = new char[(int)file.length()];
            FileReader reader = new FileReader(file);
            int numRead = reader.read(buffer);
            for (int i = 0; i < buffer.length; i += 9) {
                String shortId = new String(buffer, i, 8);
                if (!this.isAllowed(shortId)) continue;
                if (allowDuplicates) {
                    list.add(shortId);
                    continue;
                }
                if (list.contains(shortId)) continue;
                list.add(shortId);
            }
            reader.close();
        } else {
            Trace.trace(TRACE_MASKD, "   file does not exist");
        }
        Trace.trace(TRACE_MASKD, "<- UIObjectsReader.parseFile()");
    }

    private Collection getTypes(Collection source, Collection result, byte type) throws IOException {
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            if (!this.isAllowed(shortId)) continue;
            try {
                int offset = this.recordOffsets.getOffset(shortId);
                this.objectsReader.seek(offset + 9);
                byte nextType = this.objectsReader.readByte();
                if (nextType != type && (type != 49 || nextType != 53)) continue;
                result.add(shortId);
            }
            catch (InvalidIdException exc) {}
        }
        return result;
    }

    private Collection getLeaves(Collection shortIds, Collection result) throws IOException {
        Trace.trace(TRACE_MASKD, "-> UIObjectsReader.getLeaves()");
        Iterator iterator = shortIds.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            if (!this.isAllowed(shortId)) continue;
            try {
                int offset = this.recordOffsets.getOffset(shortId);
                this.objectsReader.seek(offset + 9);
                byte nextType = this.objectsReader.readByte();
                if (nextType == 50 || nextType == 52) {
                    List groupMembers = this.getChildrenShortIds(shortId);
                    this.getLeaves(groupMembers, result);
                    continue;
                }
                result.add(shortId);
            }
            catch (InvalidIdException exc) {}
        }
        Trace.trace(TRACE_MASKD, "<- UIObjectsReader.getLeaves()");
        return result;
    }

    private Set findConsoleTasksGroupShortIds(Set rootTaskShortIds) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.findConsoleTasksGroupShortIds()");
        HashSet<String> result = new HashSet<String>();
        Iterator iterator = rootTaskShortIds.iterator();
        block0: while (iterator.hasNext()) {
            String key;
            String groupShortId = (String)iterator.next();
            byte[] buffer = this.findFirstTaskShortId(groupShortId);
            if (buffer == null || (key = UIObjectsReader.getObjectIdNameKey(buffer)) == null) continue;
            Trace.trace(TRACE_MASKD, "   key is " + key);
            for (int i = 0; i < UIObjectsConstants.CONSACT.length; ++i) {
                if (!key.equals(UIObjectsConstants.CONSACT[i])) continue;
                Trace.trace(TRACE_MASKF, "   found a console tasks group, shortId is " + groupShortId);
                result.add(groupShortId);
                continue block0;
            }
        }
        if (result.size() == 0) {
            Trace.trace(TRACE_MASKF, "   could not find a console action group");
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.findConsoleTasksGroupShortIds()");
        return result;
    }

    private byte[] findFirstTaskShortId(String groupShortId) {
        byte[] buffer = null;
        List children = this.getChildrenShortIds(groupShortId);
        Iterator iterator = children.iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String childShortId = (String)iterator.next();
            try {
                buffer = this.getBuffer(childShortId);
                if (UIObjectsReader.isTask(buffer)) {
                    found = true;
                    continue;
                }
                if (!UIObjectsReader.isTaskGroup(buffer) || (buffer = this.findFirstTaskShortId(childShortId)) == null) continue;
                found = true;
            }
            catch (InvalidIdException exc) {}
        }
        if (found) {
            return buffer;
        }
        return null;
    }

    private List getLikeTaskGroupShortIds(String taskGroupShortId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsReader.getLikeTaskGroupShortIds()");
        ArrayList<String> result = new ArrayList<String>();
        try {
            byte[] buffer = this.getBuffer(taskGroupShortId);
            LocalizableText name = UIObjectsReader.getName(buffer);
            Trace.trace(TRACE_MASKF, "   LocalizableText is " + name);
            Set taskGroups = this.getShortIdsByType((byte)52);
            Iterator iterator = taskGroups.iterator();
            while (iterator.hasNext()) {
                String nextTaskGroup = (String)iterator.next();
                try {
                    buffer = this.getBuffer(nextTaskGroup);
                    LocalizableText nextName = UIObjectsReader.getName(buffer);
                    if (!name.equals(nextName)) continue;
                    Trace.trace(TRACE_MASKF, "   add next LocalizableText " + nextName);
                    result.add(nextTaskGroup);
                }
                catch (InvalidIdException exc) {}
            }
        }
        catch (InvalidIdException invalidIdException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsReader.getLikeTaskGroupShortIds(), number returned is " + result.size());
        return result;
    }

    private Set removeLikeNames(Set shortIds) {
        int i;
        String[] uniqueShortIds = new String[shortIds.size()];
        LocalizableText[] names = new LocalizableText[shortIds.size()];
        Iterator iterator = shortIds.iterator();
        int nextName = 0;
        while (iterator.hasNext()) {
            try {
                names[nextName] = null;
                uniqueShortIds[nextName] = (String)iterator.next();
                byte[] buffer = this.getBuffer(uniqueShortIds[nextName]);
                names[nextName] = UIObjectsReader.getName(buffer);
            }
            catch (InvalidIdException exc) {
                uniqueShortIds[nextName] = null;
            }
            ++nextName;
        }
        boolean removed = false;
        for (i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            for (int j = i + 1; j < names.length; ++j) {
                if (names[j] == null || !names[i].equals(names[j])) continue;
                uniqueShortIds[j] = null;
                names[j] = null;
                removed = true;
            }
        }
        if (removed) {
            shortIds.clear();
            for (i = 0; i < uniqueShortIds.length; ++i) {
                if (uniqueShortIds[i] == null) continue;
                shortIds.add(uniqueShortIds[i]);
            }
        }
        return shortIds;
    }

    private boolean isAllowed(String shortId) {
        return this.allowedShortIds == null || this.allowedShortIds.contains(shortId);
    }

    private List addConsoleTasks(String consoleTasksGroupShortId, List result) {
        List children = this.getChildrenShortIds(consoleTasksGroupShortId);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            try {
                String next = (String)iterator.next();
                byte[] buffer = this.getBuffer(next);
                if (UIObjectsReader.isGroup(buffer)) {
                    this.addConsoleTasks(next, result);
                    continue;
                }
                if (result.contains(next)) continue;
                result.add(next);
            }
            catch (InvalidIdException exc) {}
        }
        return result;
    }
}

